<p>PHP Example illustrating how to pipe i/o to command line tool</p>
 
<?php 
	// proc_open needs this setup
	 
	$descriptorspec=array( 
		0 => array("pipe", "r"), 
		1 => array("pipe", "w"), 
		2 => array("file", "/tmp/err.txt", "a") 
		); 
		
	// Note:The executable must be in a location that is accessible to user www 
	// and should be executable by everyone (.apps are by default) 
	 
	 
	// start moneyworks in interactive mode (-i) (-q = quiet, no initial greeting) 
	$process = proc_open("/usr/bin/moneyworks -iq", $descriptorspec, $pipes); 
	 
	if(is_resource($process)){ 
	 
		//writecommandtostdin 
		fputs($pipes[0], "open file='moneyworks://localhost:6699?doc=Admin@Acme.mwd6'\n"); 
		 		
		// write command to stdin
		fputs($pipes[0], "evaluate expr=/name/\n"); 
		 
		// get result from stdout
		$result = fgets($pipes[1]); 
		 
		echo("Company name is '$result'<br><br>\n"); 

		// write command to stdin
		fputs($pipes[0], 'export table=/account/ format=/[description] = [getbalance("accountcode = `"+code+"`", today())]<br>\n/\n'); 
		 
		// get result from stdout - we since there are many lines of data,
		// we'll close stdi, so that we'll get an EOF on the output
		// -- if we wanted to be clever, we'd use -h or -x and parse the output
		// more intelligently
			 
		fclose($pipes[0]);	// EOF on stdin will actually cause MW to exit
		$result = ""; 
		while(!feof($pipes[1])) 
			$result .= fgets($pipes[1],100); 
		echo $result; 
		 
		fclose($pipes[1]); 
		 
		$return_value = proc_close($process);	// pick up return value (else zombie?)
		 
		echo"command returned $return_value<br><br>\n"; 
		} 
	?>
